
function _my_change() {
    var proto = $("#protocol").val();
    if (proto == "https") {
        $("#ssl_pass_through_font").css("color", "black");
        $("#ssl_pass_through").css("color", "black");
        $("#ssl_pass_through").prop("disabled", false);

        $("#http_visit_font").css("color", "black");
        $("#http_visit").css("color", "black");
        $("#http_visit").prop("disabled", false);

        $("#ssl_visit_font").css("color", "black");
        $("#ssl_visit").css("color", "black");
        $("#ssl_visit").prop("disabled", false);

        if ($('#ssl_pass_through').prop("checked")) {
            if ($('#http_visit').prop("checked")) {
                $("#basic_auth_font").css("color", "black");
                $("#basic_auth").css("color", "black");
                $("#basic_auth").prop("disabled", false);
            } else {
                $("#basic_auth_font").css("color", "#999999");
                $("#basic_auth").css("color", "#999999");
                $("#basic_auth").prop("disabled", true);
            }
        } else {
            $("#basic_auth_font").css("color", "black");
            $("#basic_auth").css("color", "black");
            $("#basic_auth").prop("disabled", false);
        }
    } else if (proto == "http") {
        $("#ssl_pass_through_font").css("color", "#999999");
        $("#ssl_pass_through").css("color", "#999999");
        $("#ssl_pass_through").prop("disabled", true);

        $("#http_visit_font").css("color", "black");
        $("#http_visit").css("color", "black");
        $("#http_visit").prop("disabled", false);

        $("#ssl_visit_font").css("color", "black");
        $("#ssl_visit").css("color", "black");
        $("#ssl_visit").prop("disabled", false);

        $("#basic_auth_font").css("color", "black");
        $("#basic_auth").css("color", "black");
        $("#basic_auth").prop("disabled", false);
    } else if (proto == "mstsc") {
        $("#ssl_pass_through_font").css("color", "#999999");
        $("#ssl_pass_through").css("color", "#999999");
        $("#ssl_pass_through").prop("disabled", true);

        $("#http_visit_font").css("color", "#999999");
        $("#http_visit").css("color", "#999999");
        $("#http_visit").prop("disabled", true);

        $("#ssl_visit_font").css("color", "#999999");
        $("#ssl_visit").css("color", "#999999");
        $("#ssl_visit").prop("disabled", true);

        $("#basic_auth_font").css("color", "#999999");
        $("#basic_auth").css("color", "#999999");
        $("#basic_auth").prop("disabled", true);
    }
}

function parseHostAndPort(input) {
    const parts = input.split(':');
    
    if (parts.length > 2) {
        throw new Error('Invalid format: multiple colons found');
    }
    
    return {
        hostname: parts[0],
        port: parts[1] ? parts[1] : null
    };
}

function MySubmit() {
	var oForm = document.getElementById("MyForm");
	if (CType_CheckForm(oForm) == false) {
		return false;
	}

    var protocol = $("#protocol").val();
    var hp = parseHostAndPort($('#target').val());

    var sData = "_do=cmd.run&cmd=config-view;xnetc-view;public-service web rule " + $("#name").val();
    sData += " -t " + protocol;
    sData += " -h " + hp.hostname;
    if (hp.port) {
        sData += " -p " + hp.port;
    }

	if ($('#basic_auth').val()) {
        sData += " -b " + $('#basic_auth').val();
    }

    if ($('#ssl_pass_through').prop("checked")) {
        sData += " -P";
    }

    if ($('#http_visit').prop("checked")) {
        sData += " -H";
    }

    if ($('#ssl_visit').prop("checked")) {
        sData += " -S";
    }

    if ($('#self_domain').val()) {
        sData += " -s " + $('#self_domain').val();
    }

	if (! RQ_Post("/request.cgi", sData)) {
        return false;
    }

	return true;
}


